#include <stdio.h>
#include <stdlib.h>

typedef long long ll;


typedef struct { ll val; } Value;


int compare_ll(const void* a, const void* b) {
    ll valA = ((Value*)a)->val;
    ll valB = ((Value*)b)->val;
    if (valA < valB) return -1;
    if (valA > valB) return 1;
    return 0;
}


ll countPairsGeneric(Value* values, int N) {
    qsort(values, N, sizeof(Value), compare_ll);
    ll total_pairs = 0;
    ll current_count = 1;
    for (int i = 1; i < N; i++) {
        if (values[i].val == values[i-1].val) {
            current_count++;
        } else {
            if (current_count >= 2) {

                total_pairs += current_count * (current_count - 1) / 2;
            }
            current_count = 1;
        }
    }
    if (current_count >= 2) {
        total_pairs += current_count * (current_count - 1) / 2;
    }
    return total_pairs;
}


int main() {
    int N;
    scanf("%d", &N);

    Value* X_vals = (Value*)malloc(N * sizeof(Value));
    Value* Y_vals = (Value*)malloc(N * sizeof(Value));
    Value* Sum_vals = (Value*)malloc(N * sizeof(Value));
    Value* Diff_vals = (Value*)malloc(N * sizeof(Value));

    for (int i = 0; i < N; ++i) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        X_vals[i].val = x;
        Y_vals[i].val = y;
        Sum_vals[i].val = x + y;
        Diff_vals[i].val = x - y;
    }

    ll total_greetings = 0;
    total_greetings += countPairsGeneric(X_vals, N);
    total_greetings += countPairsGeneric(Y_vals, N);
    total_greetings += countPairsGeneric(Sum_vals, N);
    total_greetings += countPairsGeneric(Diff_vals, N);

    printf("%lld\n", total_greetings);

    free(X_vals);
    free(Y_vals);
    free(Sum_vals);
    free(Diff_vals);

    return 0;
}